(function() {
    'use strict';

    function addButton() {
        // Убираем дубликаты
        if ($('.download-shorts-button').length) return;

        // Создаём кнопку вручную с иконкой скачивания
        var button = $(`
            <div class="player-control__button selector download-shorts-button">
                <svg width="38" height="38" viewBox="0 0 38 38" aria-hidden="true">
                    <path d="M19 6v13m-7-7l7 7 7-7m-14 14c0 4.97 4.03 9 9 9s9-4.03 9-9-4.03-9-9-9-9 4.03-9 9z" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                <span>Скачать</span>
            </div>
        `);

        // Обработчик нажатия (hover:enter — стандарт для Lampa, работает и на ПК, и на ТВ)
        button.on('hover:enter', function() {
            // Получаем URL видео из тега <video>
            var video = $('video')[0];
            var url = video ? (video.currentSrc || video.src) : null;

            // Запасной вариант через API Lampa
            if (!url && Lampa.Player && Lampa.Player.video && Lampa.Player.video().url) {
                url = Lampa.Player.video().url;
            }

            if (url && url.startsWith('http') && !url.includes('blob:')) {
                var a = document.createElement('a');
                a.href = url;
                a.download = 'shorts_video.mp4';
                document.body.appendChild(a);
                a.click();
                document.body.removeChild(a);
                Lampa.Noty && Lampa.Noty.show('Скачивание начато!');
            } else {
                Lampa.Noty && Lampa.Noty.show('Прямой URL не найден (YouTube или защищённый поток)');
            }
        });

        // Добавляем кнопку в правую часть панели плеера
        $('.player-panel__right').append(button);
    }

    function removeButton() {
        $('.download-shorts-button').remove();
    }

    // Основной listener на открытие/закрытие полноэкранного плеера
    Lampa.Listener.follow('full', function(e) {
        if (e.type === 'start') {
            setTimeout(addButton, 1000); // Задержка, чтобы панель успела отрисоваться
        } else {
            removeButton();
        }
    });

    // Если плеер уже открыт (для теста в консоли)
    if ($('.player-panel').length) {
        setTimeout(addButton, 1000);
    }
})();