<?php
function output(...$data)
{
    $result = [];
    foreach ($data as $something) {
        if ($something instanceof Illuminate\Support\Collection) {
            $something = $something->toArray();
        }
        if (is_array($something)) {
            $something = var_export($something, true);
        }
        if (empty($something)) {
            $something = '';
        }
        if (is_object($something)) {
            if (method_exists($something, 'toArray')) {
                $something = $something->toArray();
            } elseif (method_exists($something, 'jsonSerialize')) {
                $something = $something->jsonSerialize();
            } else {
                $something = var_export($something, true);
            }
        }
        $result[] = $something;
    }
    file_put_contents(
        'test_' . date('d.m.Y') . '.log',
        '[' . date('H:i:s') . '] ' .
        implode(' ', $result) . PHP_EOL,
        FILE_APPEND
    );
}