<?php

/**
 * Проверяет корректность синтаксиса php-файла
 *
 * @param string $filepath Путь к файлу
 * @param int    $exitcode Код выхода процесса php
 * @return array Массив строк результата
 */
function php_syntax_file(string $filepath, int &$exitcode = 0): array {
    $output = [];
    exec("php -l {$filepath} 2>&1", $output, $exitcode);
    if (count($output) > 1) {
        unset($output[count($output)-1]);
    }
    return $output;
}

/**
 * Проверяет корректность синтаксиса php-кода через файл
 *
 * @param string $php_code Явный PHP-код
 * @param int    $exitcode Код выхода процесса php
 * @return array Массив строк результата
 */
function php_syntax_text(string $php_code, int &$exitcode = 0): array {
    $output = [];
    $tmp_filename = 'tmp/tmp'.time();
    file_put_contents($tmp_filename, $php_code);
    if (file_exists($tmp_filename)) {
        $output = php_syntax_file($tmp_filename, $exitcode);
        unlink($tmp_filename);
    } else {
        $exitcode = 255;
    }
    return $output;
}

/******************
 * Использование
 ******************/

$file = 'some/testfile.php'; // путь к файлу
echo implode("<br>", php_syntax_file($file)); // проверка по файлу
echo implode("<br>", php_syntax_text(file_get_contents($file))); // проверка по содержимому файла
echo implode("<br>", php_syntax_text('<?php asdfasdfasdfasdfasdf phpinfo();')); // проверка по коду