#!/bin/bash

srcPath='/mnt/Data/Фото/!_SORT/SamsungSort'
ownerId='b3f46eb5-81a6-4283-aade-d726823d7af4'

########################################################

source .env || exit 10
libHostPath="$UPLOAD_LOCATION"
libContainerPath='/usr/src/app/upload'

sql="SELECT \"id\",
    \"originalPath\",
    \"originalFileName\"
FROM asset
WHERE 1=1
    AND \"libraryId\" IS NULL
    AND \"status\" = 'active'
    # AND \"type\" = 'IMAGE'
    AND \"ownerId\" = '$ownerId'
"
echo "$sql"

IFS='|' rows=($(docker exec immich_postgres psql -U "$DB_USERNAME" -d "$DB_DATABASE_NAME" -c "$sql" -t))

awk <<< ${rows[@]} "
@load \"filefuncs\"
function join(array, start, end, sep, result)
{
    if (sep == \"\") {
       sep = \" \"
    } else if (sep == SUBSEP) { # magic value
       sep = \"\"
    }

    result = array[start]
    for (i = start + 1; i <= end; i++) {
        if (array[i] == sep) {
            continue
        }
        result = result sep array[i]
    }
    return result
}
{
    if (NR == 20) {
        exit
    }

    type=\$4
    guid=\$1
    print \"[\" NR \"] \" type \" \" guid

    immichUploadPath=\$2
    print \"\t* Immich upload path:\t\" immichUploadPath

    immichUploadPath=sprintf(\"%s/%s\", \"$libHostPath\", substr(immichUploadPath, length(\"$libContainerPath\") + 2, length(immichUploadPath)))
    n=split(immichUploadPath, arr, \"/\")
    immichUploadDir=join(arr, 1, n-1, \"/\")
    immichUploadStat=stat(immichUploadPath, fdata)
    immichUploadSize=fdata[\"size\"]
    print \"\t* Immich local dir:\t\" immichUploadDir
    print \"\t* Immich local path:\t\" immichUploadPath
    print \"\t* Immich local size:\t\" immichUploadSize

    n=split(immichUploadPath, arr, \"/\")
    immichThumbDir=join(arr, 1, n-3, \"/\") \"/\" substr(guid, 1, 2) \"/\" substr(guid, 3, 2)
    immichThumbPath=immichThumbDir \"/\" guid \"-preview.jpeg\"
    gsub(/upload/, \"thumbs\", immichThumbPath)
    immichThumbStat=stat(immichThumbPath, fdata)
    immichThumbSize=fdata[\"size\"]
    print \"\t* Immich thumb dir:\t\" immichThumbDir
    print \"\t* Immich thumb path:\t\" immichThumbPath
    print \"\t* Immich thumb size:\t\" immichThumbSize

    origHostPath=sprintf(\"%s/%s\", \"$srcPath\", \$3)
    origHostStat=stat(origHostPath, fdata)
    origHostSize=fdata[\"size\"]
    print \"\t* Original host path:\t\" origHostPath
    print \"\t* Original host size:\t\" origHostSize

    if (origHostStat != 0 && immichUploadStat != 0 && immichThumbStat != 0) {
        print \">>> BADBADBAD\"
    } else if (origHostStat == 0) {
        if (immichUploadStat == 0) {
            print \">>> ORIG OK\"
        } else {
            system(\"mkdir -p \" immichUploadDir)
            system(\"cp -f \" origHostPath \" \" immichUploadPath)
            print \">>> ORIG COPIED\"
        }
        if (immichThumbStat == 0) {
            print \">>> THUMB OK\"
        } else {
            # system(\"mkdir -p \" immichThumbDir)
            # system(\"cp -f \" origHostPath \" \" immichThumbPath)
            # print \">>> THUMB COPIED\"
            print \">>> THUMB SKIPPED\"
        }
    }

    print \"\"
}"
